#ifndef HD61830_H
#define HD61830_H

/* --- bitte an deine Hardware anpassen --- */
#define HD61830_CONTROL_PORT	PORTA
#define HD61830_CONTROL_DDR		DDRA
#define HD61830_CONTROL_PIN		PINA
#define HD61830_DATA_PORT		PORTC
#define HD61830_DATA_DDR		DDRC
#define HD61830_DATA_PIN		PINC
/* - Control Port Bits - */
#define HD61830_RS				0
/*
Register select: 
RS = 1: Instruction register
RS = 0: Data register
*/
#define HD61830_RW				1
/*
Read/Write:
R/W = 1: HD61830 to MPU
R/W = 0: MPU to HD61830
*/
#define HD61830_E				2
/*
Enable: 
Data is written at the fall of E
Data can be read while E is 1
*/
//#define HD61830_CS				3
/*
Chip select: 
Selected state with CS = 0
not implemeted jet
*/

#define HD61830_XPIXELS	240
#define HD61830_YPIXELS 64
#define HD61830_FONT_X	5
#define HD61830_FONT_Y  7
/* --- ab hier muss nix mehr gendert werden --- */

#define HD61830_CHARS_LINE (HD61830_XPIXELS/(HD61830_FONT_X + 1))
#define HD61830_CHARS_ROW (HD61830_YPIXELS/(HD61830_FONT_Y + 1))

// Initialisiert das lcd und die IO Ports
void hd61830Init(void);

// moves the cursor/position to Home (upper left corner)
void hd61830Home(void);

// clears the LCD display
void hd61830Clear(void);

// moves the cursor/position to the row,col requested
// ** this may not be accurate for all displays
void hd61830GotoXY(unsigned char x, unsigned char y);

// prints a series of bytes/characters to the display
void hd61830PrintData(char* data, unsigned char nBytes);

#endif
