/*
*
*
*
*/

#include <avr/io.h>
#include <avr/signal.h>
#include <avr/interrupt.h>
#include "global.h"
#include "rtc.h"
#include "lcd.h"
#include "adxl.h"

#define S_ABSOLUT 0
#define S_RELATIV 1
#define S_SPEED 2


#define LED_ON	(sbi(PORTB,3))
#define LED_OFF	(cbi(PORTB,3))
#define TASTE_1 (bit_is_clear(PIND,5))
#define TASTE_2 (bit_is_clear(PIND,4))

t_adxl adxlx,adxly;

inline void init(void){
	rtcInit();
	lcdInit();
//	sbi(DDRB,3); // wird jetzt in lcd init gemacht
	PORTD = 0xfc;  // pull up fr INT0,1
	GIMSK = 0xc0;  // int0,1 aktivieren
	MCUCR = 0x0f;  // int0,1 steigende flanke
	TCCR1B = 0x01; // count up mit F_CPU
	sei(); // interrupts an
}// init end


/*----------------Timer Interrupts--------------------*/

// alle 32ms
SIGNAL(SIG_OVERFLOW0)
{
	rtcInt();
}

/*----------------------------------------------------*/

/*----------------External Interrupts-----------------*/
// adxl x int

SIGNAL(SIG_INTERRUPT0)
{  
 	adxlInt(&adxlx,bit_is_set(MCUCR,ISC00));
 	MCUCR = (MCUCR&0xfe)|((MCUCR+1)&0x1);
}
// adxl y int
SIGNAL(SIG_INTERRUPT1)
{  
 	adxlInt(&adxly,bit_is_set(MCUCR,ISC10));
 	MCUCR = (MCUCR&0xfb)|((MCUCR+4)&0x4);
}

/*----------------------------------------------------*/

u08 IntToStrZero(u08* s,s16 i,u16 divisor)
/* connverts 16 bit unsigned integer to string, leading zero, divisor=10,100,1000,10000*/
{
    u08 c,x=1;
    if(i<0) 
    {
    	s[0]='-';
    	i=-i;
    } else s[0]=' ';
    do {
        c = (u08)(i/divisor);
        s[x++]=c +'0';
        i -= c*divisor;
        divisor /= 10;
    } while (divisor);
   return x; 
}


/*----------------Main Loop---------------------------*/
int main(void){
  u08 s[20];
  u08 state = 0,i;
  s16 x, y, xOffs, yOffs;
  init();
 
  for(;;)
  {
  	i=0;
	if TASTE_1
	{
		state++;
		while TASTE_1;
	}
	if TASTE_2 
	{
		xOffs = adxlx.duty_cycle;
		yOffs = adxly.duty_cycle;
  		x=0;
  		y=0;
	}
  	switch(state)
  	{
  		case S_ABSOLUT:
  		s[i++]='A';
  		xOffs = 0;
		yOffs = 0;
  		x=0;
  		y=0;
		break;
  		
  		case S_RELATIV:
  		s[i++]='R';
  		x=0;
  		y=0;
  		break;
  		
  		case S_SPEED:
  		s[i++]='S';
  		break;
  		default: state=0; break;

  	}
	x += (adxlx.duty_cycle - xOffs);
	y += (adxly.duty_cycle - yOffs);
	s[i++]=' ';
	s[i++]='X';
  	i+=IntToStrZero(s+i,x,10000);
	s[i++]=' ';
	s[i++]='Y';
  	i+=IntToStrZero(s+i,y,10000);
//	s[11]=' ';
//  	IntToStrZero(s+16,MCUCR,100);
	lcdGotoXY(0,0);
	lcdPrintData(s,i);
	rtcDelay(150);
	
  }// for ever
}// main


