#include <avr/io.h>
#include "global.h"
#include "adxl.h"

#define COUNTER_REG	inw(TCNT1L)

void adxlInt(t_adxl* adxl,u08 rising)
{
	u16 cr = COUNTER_REG;
	u16	pulse_lenght;
	if(rising)
	{
		if(adxl->rising_time>=cr) pulse_lenght = (0xffff - adxl->rising_time) + cr;
		else pulse_lenght = cr - adxl->rising_time;
		
		adxl->duty_cycle = (adxl->duty_cycle>>1) + ((u32)adxl->pulse_width*500)/((u32)pulse_lenght);
		adxl->rising_time = cr;
	} else 
	{
		if(adxl->rising_time>=cr) adxl->pulse_width = (0xffff - adxl->rising_time) + cr;
		else adxl->pulse_width = cr - adxl->rising_time;
	}
	
}