/*	ad7739 main.c
*
* 2Do:
* ad Converter auslesen und an uart senden
*
* sollte funzen:
* - 
* - 
*
* das funzt:
*
*/
#include <avr/interrupt.h>
#include <avr/io.h>
#include <avr/signal.h>
#include "global.h"
#include "uart.h"
#include "vt100.h"
#include "rprintf.h"
#include "a2d.h"
#include "spi.h"
#include "lcd.h"
#include "ad7739.h"

u08 lcdbuf[17];
/*-------------Initalisierung------------------*/
void init(void){
	lcdInit();
	lcdGotoXY(0,0);
	lcdPrintData("AD7739 24Bit ADC",16);

	uartInit();
  	// set the baud rate of the UART for our debug/reporting output
	uartSetBaudRate(9600);
	// initialize rprintf system
	rprintfInit(uartSendByte);
	// initialize vt100 library
	//vt100Init();
	
	// clear the terminal screen
	//vt100ClearScreen();
	a2dInit(); 
	spiInit();
  // pull up
  //DDR
  
	sei(); // interupt enable
	rprintf("AD7739 Test Programm \r\n");
}// init end


/*----------------Timer Interrupts--------------------*/

SIGNAL(SIG_OVERFLOW2)
{
}

/*----------------------------------------------------*/

/*----------------External Interrupts-----------------*/

/*----------------------------------------------------*/

/*---------------- Functions -------------------------*/

void delay(void)
{
	int i,j;
	for(i=0;i<10000;i++)
		for(j=0;j<100;j++) asm volatile ("nop");
}

u08 IntToStrZero(u08* s,u32 i,u32 divisor)
/* connverts 32 bit unsigned integer to string, leading zero, divisor=10,100,1000,10000*/
{
    u08 c,x=0;
    do {
        c = (u08)(i/divisor);
        s[x++]=c +'0';
        i -= c*divisor;
        divisor /= 10;
    } while (divisor);
   return x; 
}

/*----------------------------------------------------*/

/*----------------Main Loop---------------------------*/
int main(void)
{
	u08 i,x;
	u32 result;
	double voltage;
	init();
	ad7739Reset();
//	ad7739SetReg(AD7739_MODE|0,1,0x42); // single conversion 24bit
//	ad7739SetReg(AD7739_CHANNEL_CONVERSION_TIMEX|0,1,0xff); // channel0: slowest conversion rate
//	ad7739SetReg(AD7739_CHANNEL_SETUPX|0,1,0x05); // channel0: +2.5V range
	for(;;)
	{
/*		rprintf("IO            =%x\r\n",(u08)ad7739ReadReg(AD7739_IO,1));
		rprintf("Revision      =%x\r\n",(u08)ad7739ReadReg(AD7739_REVISION,1));
		rprintf("Test          =%x\r\n",(u08)ad7739ReadReg(AD7739_TEST,1));
		rprintf("Status        =%x\r\n",(u08)ad7739ReadReg(AD7739_STATUS,1));
		rprintf("Mode          =%x\r\n",ad7739ReadReg(AD7739_MODE|i,1));
		rprintf("Checksum      =");
		rprintfNum(10, 6, FALSE, ' ', (u16)ad7739ReadReg(AD7739_CHECKSUM,2));
		rprintf("\r\nZero Scale Cal=");
		rprintfNum(10, 10, FALSE, ' ', ad7739ReadReg(AD7739_ZERO_SCALE_CAL,3));
		rprintf("\r\nFull Scale Cal=");
		rprintfNum(10, 10, FALSE, ' ', ad7739ReadReg(AD7739_FULL_SCALE_CAL,3));
*/
		for(i=0;i<1;i++)
		{
			result = ad7739SingleConversion(i);
			//result = ad7739GetReg(AD7739_CHANNELX|i,3);
			voltage = (double)result/0xffffff*2.75;
			rprintf("A%x",i);
			rprintfu32(result);
			rprintf("\n");
			ad7739SetReg(AD7739_MODE|0,1,0x42); // single conversion 24bit
/*			rprintf("\r\n Channel %d Z =",i);
			rprintfNum(10, 10, FALSE, ' ',ad7739ReadReg(AD7739_CHANNEL_ZEROX|i,3));
			rprintf("\r\n Channel %d F =",i);
			rprintfNum(10, 10, FALSE, ' ',ad7739ReadReg(AD7739_CHANNEL_FULLX|i,3));
			rprintf("\r\n Channel %d S =%x\r\n",i,ad7739ReadReg(AD7739_CHANNEL_STATUSX|i,1));
			rprintf(" Channel %d U =%x\r\n",i,ad7739ReadReg(AD7739_CHANNEL_SETUPX|i,1));
			rprintf(" Channel %d C =%x\r\n",i,ad7739ReadReg(AD7739_CHANNEL_CONVERSION_TIMEX|i,1));
			*/
		}
	  	x=IntToStrZero(lcdbuf,(u32)(voltage*10000000),10000000);
		lcdGotoXY(0,1);
		lcdPrintData(lcdbuf,x);

		delay();
	}// for(ever)
}// main

