#ifndef AD7739_H
#define AD7739_H

#include "global.h

#define AD7739_COM	0x00
#define AD7739_IO	0x01
#define AD7739_REVISION	0x02
#define AD7739_TEST	0x03
#define AD7739_STATUS	0x04
#define AD7739_CHECKSUM	0x05 //16bit
#define AD7739_ZERO_SCALE_CAL	0x06 //24bit
#define AD7739_FULL_SCALE_CAL	0x07 //24bit

// one register or every channel
#define AD7739_CHANNELX	0x08 //24bit (0x08-0x0f)
#define AD7739_CHANNEL0	0x08 //24bit
#define AD7739_CHANNEL1	0x09 //24bit
#define AD7739_CHANNEL2	0x0a //24bit
#define AD7739_CHANNEL3	0x0b //24bit
#define AD7739_CHANNEL4	0x0c //24bit
#define AD7739_CHANNEL5	0x0d //24bit
#define AD7739_CHANNEL6	0x0e //24bit
#define AD7739_CHANNEL7	0x0f //24bit
#define AD7739_CHANNEL_ZEROX	0x10 //24bit (0x10-0x17)
#define AD7739_CHANNEL_FULLX	0x18 //24bit (0x18-0x1f)
#define AD7739_CHANNEL_STATUSX	0x20 //8bit
#define AD7739_CHANNEL_SETUPX	0x28 //8bit
#define AD7739_CHANNEL_CONVERSION_TIMEX	0x30 //8bit
#define AD7739_MODE	0x38 //8bit

// bit settings
#define AD7739_SETUP_PLUS_MINUS125V	0x00
#define AD7739_SETUP_PLUS_MINUS250V	0x04
#define AD7739_SETUP_PLUS250V	0x05
#define AD7739_SETUP_STAT_OPT	0x10 //0=RDY bit in STATUS register is set to 1 when conversion is ready
#define AD7739_MODE_CONTINUOUS_CONVERSION 0x20
#define AD7739_MODE_SINGLE_CONVERSION 0x40
#define AD7739_MODE_24BIT 0x02
#define AD7739_STATUS_RDY 0x08

void ad7739Init(void);
unsigned long ad7739GetReg(unsigned char reg, unsigned char nbytes);
unsigned long ad7739GetReg(unsigned char reg, unsigned char nbytes)
void ad7739Reset(void);
unsigned long ad7739SetReg(unsigned char reg, unsigned char nbytes, unsigned long data);
unsigned long ad7739SingleConversion(unsigned char channel);


#endif