
#include <avr/io.h>
#include "ad7739.h"
#include "spi.h"

unsigned long ad7739GetReg(unsigned char reg, unsigned char nbytes)
{
	unsigned long rxData = 0;
	unsigned char i;
	
	// send register adress and read flag
	reg &= 0x3f;
	spiTransferByte((0x40)|reg);
	
	for(i=nbytes;i>0;i--)
	{
		if(i==1) rxData |= (unsigned long)spiTransferByte(0);
		else if(i==2) rxData |= (unsigned long)spiTransferByte(0)*0x100;
		else if(i==3) rxData |= (unsigned long)spiTransferByte(0)*0x10000;
	}

	// return the received data
	return rxData;

}
void ad7739Reset(void)
{
	spiTransferByte(0x00);
	spiTransferByte(0xff);
	spiTransferByte(0xff);
	spiTransferByte(0xff);
	spiTransferByte(0xff);
}

unsigned long ad7739SetReg(unsigned char reg, unsigned char nbytes, unsigned long data)
{
	unsigned long rxData = 0;
	unsigned char i;
	
	// send register adress and not read flag
	reg &= 0x3f;
	spiTransferByte((0x00)|reg);
	
	for(i=nbytes;i>0;i--)
	{
		if(i==1) rxData |= (unsigned long)spiTransferByte(data);
		else if(i==2) rxData |= (unsigned long)spiTransferByte(data/0x100)*0x100;
		else if(i==3) rxData |= (unsigned long)spiTransferByte(data/0x10000)*0x10000;
	}

	// return the received data
	return rxData;

}

unsigned long ad7739SingleConversion(unsigned char channel)
{
	unsigned long data = 0;
	unsigned short i;
	unsigned char status;
	channel &= 0x07;
	ad7739SetReg(AD7739_CHANNEL_CONVERSION_TIMEX|channel,1, 0xff); // slowest conversion rate
	ad7739SetReg(AD7739_CHANNEL_SETUPX|channel,1, AD7739_SETUP_PLUS250V); // +2.5V range
	ad7739SetReg(AD7739_MODE|channel,1, AD7739_MODE_SINGLE_CONVERSION|AD7739_MODE_24BIT); // single conversion 24bit
	for(i=0xffff;i;i--)
	{
		status = ad7739GetReg(AD7739_CHANNEL_STATUSX|channel, 1);
		if(status & AD7739_STATUS_RDY)
		{
			data = ad7739GetReg(AD7739_CHANNELX|channel,3);
			break;
		}
	}
	return data;
}

void ad7739Init(void)
{
	ad7739Reset();
}