/*
* GameBoy Camera Treiber fr Atmel atmega128 von Maximilian Laiacker <mlaiacker@gmx.de>
* http://der-max.no-ip.org
*/
#ifndef CAM_H
#define CAM_H

#define IMAGE_WIDTH	(128)
#define IMAGE_HEIGHT	(128)
#define IMAGE_SIZE	(IMAGE_WIDTH*IMAGE_HEIGHT) // = 16384
#define IMAGE_DOTS	(IMAGE_WIDTH*IMAGE_HEIGHT)
// die unteren 5 zeilen sind immer grau
#define IMAGE_REAL_WIDTH  (128)
#define IMAGE_REAL_HEIGHT (123)
#define IMAGE_REAL_DOTS	  (IMAGE_REAL_WIDTH*IMAGE_REAL_HEIGHT)

#define CAM_REG_C1	2
#define CAM_REG_C0	3
#define CAM_REG_P	4
#define CAM_REG_M	5
#define CAM_REG_X	6

#define camGetExposure()	(gbCam.reg[CAM_REG_C0] + (gbCam.reg[CAM_REG_C1]<<8))
#define camSetExposure(value)	camSetReg(CAM_REG_C0, value&0xff); camSetReg(CAM_REG_C1, value>>8)
#define camGetReg(addr)		gbCam.reg[addr]

/* !! Achtung 16kB (16384 Byte) RAM bentigt !!*/
unsigned char image[IMAGE_SIZE];
/* ------------------------------------------  */

struct {
	unsigned char reg[8];
	unsigned char istBrightness;
	unsigned char lastBrightness;
	unsigned short lastExposure;
	unsigned char sollBrightness;
	/* automatische Belichtungssteuerung eingeschaltet?*/
	unsigned char autBrightness;
	/* Belichtung des Bildes ist ok*/
	unsigned char brightnessOK;
} gbCam;

void           camInit(void);
void           camReset(void);
unsigned char  camSetReg(unsigned char addr, unsigned char data);
short          camNewImage(void);
unsigned char  camGetBrightness(void); // durschnittliche helligkeit des Bildes
short          camDoAutoBrightness(void);

#endif
