/*
*
* GameBoy Camera Treiber fr Atmel atmega128 von Maximilian Laiacker <mlaiacker@gmx.de>
* http://der-max.no-ip.org
* 
* Getestet und entwickelt auf dem Roboter "Black Box 2".
* es wird umbedingt ein externer Speicher bentigt da mir kein AVR bekannt ist der 16kB
* internes SRAM hat.
*
* C-Compiler: WINAVR 20030913
*
* Wie man das Ram an den atmeg128 anschlisst kann man im Datenblatt nachlesen.
* Wichtig ist noch dem Linker mitzuteilen das er das externe RAM auch nutzt.
* Dazu frt man im makefile z.B.
*   LDFLAGS = -Wl,-Tdata,0x801100,-Map=$(TARGET).map,--cref
* ein.
* Wichtig ist das "-Tdata,0x801100"
* Nun werden alle statischen Variablen ab der RAM Adresse 1100 gespeichert.
* und da beginnt beim atmega128 das externe RAM.
* Dazu findet man auch noch was in der Dokumentation der avr-libc unter "Related Pages/Using malloc()".
*
* Zur laufzeit sollte man nun dem MCU auch noch mitteilen das er da noch RAM hat: sbi(MCUCR,SRE).
* Der Stack beginnt wie normal ab 1100 (intern) nach oben zu wachsen.
* Also volle 4kB Stack. Der interne Ram wird auch dreimal schneller angesprochen.
* ach noch was...
* der externe RAM wird nicht automatich mit nullen initalisiert also mssen alle statischen variablen auf jeden
* fall im Programm initalisiert werden.
*
* So nun noch was zum Kamera Treiber:
* Anpassungen im Quelltext mssen bei den Ein- und Ausgngen gemacht werden.
* Bei der initalisierung der Datenrichtungen in camInit().
*
* Einbinden in das Programm:
* 1. camInit()
* 2. Register setzten
* 3. Sollbelichtung setzten
* 4. camNewImage()
* 5. camDoAutoBrightness()
* 6. Belichtung OK? ->7. sonst ->4.
* 7. Bild verarbeiten
* 8. ->4.
* Anfangswerte fr die Register:
0,192
1,0x7
2,4
3,0
4,0x01
5,0x00
6,0x01
7,0x07
*/

#include <avr/io.h>
#include <string.h>
#include "cam.h"

// CAM-Control bits
/* *********** Bitte anpassen *************** */
#define CAM_SIN_HI   	(ioSetBit(12))
#define CAM_SIN_LOW   	(ioClearBit(12))
#define CAM_LOAD_HI  	(ioSetBit(14))
#define CAM_LOAD_LOW  	(ioClearBit(14))
#define CAM_START_HI 	(ioSetBit(15))
#define CAM_START_LOW 	(ioClearBit(15))
#define CAM_SCK_HI	(sbi(PORTB,7))
#define CAM_SCK_LOW	(cbi(PORTB,7))
#define CAM_RESET_HI 	(ioSetBit(13))
#define CAM_RESET_LOW 	(ioClearBit(13))

/* Konvertierung starten mit dem Befehl */
#define CAM_AD_START		(io(129)=0)
/* so den AD Wandler auslesen */
#define CAM_AD_READ		(io(129))
/* 'Read' Signal von der Kamera */
#define CAM_READ	(bitisset(io(IO2_BOARD_ADDR+0x30),7))
/* ****************************************** */

/* ein Tackt an die Kamera ausgeben */
#define CAM_TICK	CAM_SCK_HI;CAM_SCK_LOW;

/*  */
void camInit(void)
{
	// Bild lschen
	memset(image,0,sizeof(image));
	memset(gbCam.reg,0,sizeof(gbCam.reg));
	// Datenrichtungen setzen
/* *********** Bitte anpassen *************** */
	sbi(DDRB,7); // tackt
	cbi(DDRD,0); // read
/* ****************************************** */
	Cam_Reset();
	gbCam.brightnessOK = 0;
	gbCam.autBrightness = 1;
}
/* Kamera Register setzten */
unsigned char camSetReg(unsigned char addr, unsigned char data)
{
/* ok, ist noch nicht optimal gelst, funzt aber */
	if(addr>7) return 0;
	CAM_LOAD_LOW;
	CAM_SCK_LOW;
	if(addr&4) CAM_SIN_HI; else CAM_SIN_LOW;
	CAM_TICK;
	if(addr&2) CAM_SIN_HI; else CAM_SIN_LOW;
	CAM_TICK;
	if(addr&1) CAM_SIN_HI; else CAM_SIN_LOW;
	CAM_TICK;
	if(data&128) CAM_SIN_HI; else CAM_SIN_LOW;
	CAM_TICK;
	if(data&64) CAM_SIN_HI; else CAM_SIN_LOW;
	CAM_TICK;
	if(data&32) CAM_SIN_HI; else CAM_SIN_LOW;
	CAM_TICK;
	if(data&16) CAM_SIN_HI; else CAM_SIN_LOW;
	CAM_TICK;
	if(data&8) CAM_SIN_HI; else CAM_SIN_LOW;
	CAM_TICK;
	if(data&4) CAM_SIN_HI; else CAM_SIN_LOW;
	CAM_TICK;
	if(data&2) CAM_SIN_HI; else CAM_SIN_LOW;
	CAM_TICK;
	if(data&1) CAM_SIN_HI; else CAM_SIN_LOW;
	CAM_SCK_HI;
	CAM_LOAD_HI;
	CAM_SCK_LOW;
	CAM_LOAD_LOW;
	/* abspeichern reg array fr lesenden zugriff */
	gbCam.reg[addr] = data;
	return 1;
}

void camReset(void)
{
	CAM_START_LOW;
	CAM_SCK_LOW;
	CAM_RESET_LOW;
	CAM_SCK_HI;
	CAM_RESET_HI;
	CAM_SCK_LOW;
}
/* neues Bild machen */
unsigned short camNewImage(void)
{
	unsigned short i, j;
/* Bild machen */
	CAM_SCK_LOW;
	CAM_START_HI;
	CAM_SCK_HI;
	CAM_SCK_LOW;
	CAM_START_LOW;
/* Bild belichten */
	for(i=0;(i<0xff);i++)
	{
	  for(j=0;(j<0xffff);j++)
	  {
		CAM_TICK;
		if (CAM_READ) break;
	  }
          if (CAM_READ) break;
	}
/* Timeout */
	if(!CAM_READ) return 0;
/* Bild auslesen */
	CAM_SCK_HI;
	CAM_SCK_LOW;
  	CAM_AD_START;
	for(j=0;j<(IMAGE_DOTS);j++)
	{
		image[j]=CAM_AD_READ;
		CAM_SCK_HI;
		CAM_SCK_LOW;
	  	CAM_AD_START;
	}
/* "Belichtungszeit" zurck geben */
	return i;
}
/*
  Helligkeit ermitteln.
*/
unsigned char camGetBrightness(void)
{
	long sum=0;
	unsigned short i;
/* jedes 8. pixel berechnen O(1968) */
	for(i=0;i<IMAGE_REAL_DOTS;i+=8)
	{
		sum+=image[i];
	}
/*
128*123*255/8/2048 = 245 fast 255
2^11 = 2048
*/
	return (gbCam.istBrightness = sum>>11);
}

/* Belichtung anpassen.
* Gibt Abweichung vom Sollwert zurck.
*/
short camDoAutoBrightness(void)
{
	long newExposure = 0;
	short error;
	/* Helligkeit messen */
	camGetBrightness();
	/* abweichung vom sollwert */
	error = gbCam.sollBrightness - gbCam.istBrightness;
	/* belichtung OK ? */
	if(error/20 == 0) gbCam.brightnessOK = 1; else gbCam.brightnessOK = 0;
	/* Belichtungszeit anpassen ? */
	if(gbCam.autBrightness == 0) return error;
	/* neue Belichtungzeit ermitteln */
	newExposure = (error*3*(1 + camGetExposure()/1000)) + camGetExposure();
	if(newExposure < 1) newExposure = 1;
	else if(newExposure > 0xffff) newExposure = 0xffff;
	/* Belichtungszeit anpassen ! */
	camSetExposure((u16) newExposure);
	gbCam.lastExposure = camGetExposure();
	gbCam.lastBrightness = gbCam.istBrightness;
	return error;
}

