#include <avr/pgmspace.h>
#include <string.h>
#include <ctype.h>
#include <stdlib.h>
#include "global.h"
#include "strings.h"

void strclr(string s){
  u08 i;
  for(i=0;i<MAX_STR_LEN;i++) s[i]=0;
}

int strcomp(u08 s1[],u08* s2){
  u08 i;
  string s3;
  s3[0]=0;
  for (i=0;(i<MAX_STR_LEN)||(s2[i]==0);i++) s3[i]=PRG_RDB(&s2[i]);
  return strcasecmp(s1,s3);
}
/*
int strncomp(u08 s1[],u08* s2,u08 n){
  u08 i;
  string s3; 
  for (i=0;i<MAX_STR_LEN;i++) s3[i]=PRG_RDB(&s2[i]);
  return strncasecmp(s1,s3,n);
}*/


void addchar(u08 s[],u08 c){
  if (strlen(s)<(MAX_STR_LEN-1)){	
    u08 len=strlen(s);	
    s[len]=c; s[len+1]=0;
  }
}

void subchar(u08 s[]){
  if (s[0]!=0) s[strlen(s)-1]=0;
}

void addstr(u08 s[],u08 s2[]){
  u08 i;
  for (i=0;(i<strlen(s2))&&(strlen(s)<MAX_STR_LEN);i++) addchar(s,s2[i]);
}

void addprogstr(u08 s1[],u08 *s2){
  u08 i;
  for (i=0;(PRG_RDB(&s2[i])!=0)&&(strlen(s1)<MAX_STR_LEN);i++) addchar(s1,PRG_RDB(&s2[i]));
}

void IntToStr(u08 s[],long i)
/* connverts 16 bit signed integer to string */
{
    long divisor;
    char c;
    
    if (i<0) {
      addchar(s,'-');
      i=-i;
    }
    for (divisor=1;(i/divisor)>=10;divisor*=10);
    
    do {
        c = (char)(i/divisor);
        addchar(s,c + '0');
        i -= c*divisor;
        divisor /= 10;
    } while (divisor);
    
}

void IntToStrZero(u08 s[],u16 i,u16 divisor)
/* connverts 16 bit unsigned integer to string, leading zero divisor=10,100,1000,10000*/
{
    char c;
    do {
        c = (char)(i/divisor);
        addchar(s,c + '0');
        i -= c*divisor;
        divisor /= 10;
    } while (divisor);
    
}

void Binary(u08 s[],u08 Data){
  u16 i;  
  for (i=7;i>=0;i--)
    if(Data & (1<<i)) addchar(s,'1');
      else addchar(s,'0');
}

void Binary16(u08 s[],u16 Data){
  u16 i;  
  for (i=15;i>=0;i--)
    if(Data & (1<<i)) addchar(s,'1');
      else addchar(s,'0');
}

void IntToHexStr(u08 s[],u16 Data)
{
  u16 i;
  for(i=3;i>0;i--){
    u08 Character = Data&(0xf<<i);
    if (Character>9)
    {
        Character+='A'-10;
    }
    else
    {
        Character+='0';
    }
    addchar(s,Character);
  }    
}


u08 xchar2val(u08 c)
{
	if (c >= '0' && c <= '9')
		return c - '0';
	if (c >= 'A' && c <= 'F')
		return c - 'A' + 10;	
	if (c >= 'a' && c <= 'f')
		return c - 'a' + 10;	
	return 0;
}


s16 StrToVal(u08 ps[]){
//  u08 pos;
  u16 retval=0;
//  string s;
//  s[0]=0;
  
  if ((ps[0]=='0')&&(ps[1]=='b')){
/*    for(pos=2;pos<strlen(ps);pos++) s[pos-2]=ps[pos];
    if (strlen(s)>16) return 0;
    for (pos=0;pos<strlen(s);pos++) switch (s[strlen(s)-1-pos]) {
                                        case '0': break;
                                        case '1': retval|=(1<<pos);
                                                  break;
                                        default : return 0;
                                      }*/
    retval=strtol(&ps[2],NULL,2);
    return retval;
  }
/*  if ((ps[0]=='0')&&(ps[1]=='x')){
    for(pos=2;pos<strlen(ps);pos++) s[pos-2]=ps[pos];
    if (strlen(s)>4) return 0;
    for (pos=0;pos<strlen(s);pos++) if (isxdigit(s[strlen(s)-1-pos]))
                                       retval|=(xchar2val(s[strlen(s)-1-pos])<<(pos<<2));
                                     else
                                       return 0;

    return retval;
  }
  return ((s16)atoi(ps));
  */
  return (s16)strtol(ps,NULL,0);
}


u08 isalldigit(u08 *s){
 u08 i;
  for(i=0;s[i]!=0;i++){
    if(!isdigit(s[i])) return 0;
  }
  return 1;
}