#ifndef RTC_H
#define RTC_H
// Real Time Clock

/*
#define mSec(time)	(      ((time.ms)%1000) )
#define Sec(time)	((u08) ((time.ms)/1000) )
#define Min(time)	(      ((time.min)%60)	)
#define Hour(time)	((u08) ((time.min)/60)  )
*/
#define RTC_PRESCALER		(1024)
#define RTC_TICKS_TO_OVERFLOW	(250)
#define	RTC_OVERFLOW_TIME	(64) //((RTC_PRESCALER*RTC_TICKS_TO_OVERFLOW*1000)/F_CPU) //[ms]
#define RTC_START_VAL		(0xff-RTC_TICKS_TO_OVERFLOW)

#define mSec(time)	((u16) ((time)%1000) )
#define Sec(time)	((u08) (((time)/1000)%60) )
#define Min(time)	((u08) (((time)/60000)%60))
#define Hour(time)	((u08) (((time)/3600000)%24))



void RTC_Init(void);
void UpdateTime(void);
unsigned long GetmSec(void); // ms
unsigned long GetSec(void);
unsigned long GetMin(void);
unsigned long GetHour(void);
unsigned long GetTime(void);
unsigned long SetTime(unsigned long t);
void RTC_Delay(unsigned long ms);
unsigned char RTC_Einschaltverz(unsigned char bedingung,unsigned long verz,unsigned long *timevar);

#endif
