#include <avr/io.h>
//#include "global.h"
#include "beep.h"
#include "rtc.h" // fr pause bei Beep() wenn nicht vorhanden, selber delay Funktion schreiben
#include "global.h"

#ifndef F_CPU
#define F_CPU	4000000
#endif
/* Beeper using Timer/Counter2 */
#define BEEP_TCCR	TCCR2
#define BEEP_OCR	OCR2
#define BEEP_DDR	DDRB
#define BEEP_PORT_BIT 3
void beepInit(void)
{
	//Set timer/counter2 to CTC Mode
	sbi(BEEP_TCCR,WGM21);
	cbi(BEEP_TCCR,WGM20);
	//toggle output on each compare
	sbi(BEEP_TCCR,COM20);
	cbi(BEEP_TCCR,COM21);
	//set ddr of OCR Pin
	sbi(BEEP_DDR,BEEP_PORT_BIT);
	//initially turn off timer
	beepSetFreq(0);
}

void beepSetFreq(unsigned long freq)
{
	unsigned char x=0;
	unsigned long ocr2=0;
	unsigned short n[7]={1,8,32,64,128,256,1024};
	if(freq<=0)
	{
		// turn off timer
		BEEP_TCCR = (BEEP_TCCR&0xf8);
		return;
	}
/* ocr2 wert suchen */
    ocr2=F_CPU/(2*freq*n[x])-1;
	while(ocr2>255)
	{
		x++;
		if(x>7)
		{
			// frequenz zu klein
			// timer off
			BEEP_TCCR = (BEEP_TCCR&0xf8);
			return;
		}
		ocr2=F_CPU/(2*freq*n[x])-1;
	}
	// set registers
	 BEEP_OCR = ocr2;
	 BEEP_TCCR = (BEEP_TCCR&0xf8)|(x+1);
}
#ifndef RTC_H
void beepDelay(unsigned long x)
{
  unsigned long i;
  for (i=0;i<100*x;i++);
}
#else
#define beepDelay	RTC_Delay
#endif

void Beep(unsigned long freq, unsigned long delay)
{
	beepSetFreq(freq);
	if(delay)
	{
		beepDelay(delay);
		beepSetFreq(0);
	}
}
