#include <avr/io.h>
#include <avr/interrupt.h>
#include "adc.h"
#include "global.h"

void adcInit(void)
{
  ADCSR = 1<<ADEN|0<<ADIE|0<<ADIF|1<<ADPS2|1<<ADPS1|1<<ADPS0;
}


unsigned short AD(unsigned char x)
{
  unsigned short result;
  ADMUX = (ADMUX & 0xF0) | x;
  sbi(ADCSRA,ADSC);
  while (bit_is_set(ADCSRA,ADSC));
  
  result=inp(ADCL);
  result+=inp(ADCH)<<8;
  return result;
}
