#include <avr/io.h>
#include "global.h"
#include "pwm.h"

#define INPUT1_PORT	(PORTD)
#define INPUT1_BIT	7
#define INPUT2_PORT	(PORTB)
#define INPUT2_BIT	0
#define INPUT3_PORT	(PORTD)
#define INPUT3_BIT	5
#define INPUT4_PORT	(PORTD)
#define INPUT4_BIT	6


void PWM_Init(void){
 // Cleared on compare match, up-counting. Set on compare match, down-counting (non-inverted PWM). 9Bit PWM
 outp(1<<COM1A1|0<<COM1A0|1<<COM1B1|0<<COM1B0|1<<WGM11|0<<WGM10,TCCR1A); 
 // fTCK1 = CK 00000001
 outp(0<<WGM12|0<<WGM13|1<<CS10|0<<CS11|0<<CS12,TCCR1B);
 
  // Cleared on compare match, up-counting. Set on compare match, down-counting (non-inverted PWM). 9Bit PWM
 //outp(1<<COM1A1|0<<COM1A0|1<<COM1B1|0<<COM1B0|1<<PWM11|0<<PWM10,TCCR1A);
  // fTCK1 = CK 00000001
 //outp(1<<CS10|0<<CS11|0<<CS12,TCCR1B);
 
 sbi(DDRB,1); // Datenrichtung PWMA
 sbi(DDRB,2); // Datenrichtung PWMB
 
 sbi(DDRD,INPUT1_BIT); // Input 1
 sbi(DDRB,INPUT2_BIT); // Input 2
 sbi(DDRD,INPUT3_BIT); // Input 3
 sbi(DDRD,INPUT4_BIT); // Input 4
 

 
 PWMA_Set(0);
 PWMB_Set(0);
}

inline void AForward(void){
 sbi(INPUT1_PORT,INPUT1_BIT);
 cbi(INPUT2_PORT,INPUT2_BIT);
}

inline void ABackward(void){
 cbi(INPUT1_PORT,INPUT1_BIT);
 sbi(INPUT2_PORT,INPUT2_BIT);
}

inline void AStop(void){
 cbi(INPUT1_PORT,INPUT1_BIT);
 cbi(INPUT2_PORT,INPUT2_BIT);
}

inline void BForward(void){
 sbi(INPUT3_PORT,INPUT3_BIT);
 cbi(INPUT4_PORT,INPUT4_BIT);
}

inline void BBackward(void){
 cbi(INPUT3_PORT,INPUT3_BIT);
 sbi(INPUT4_PORT,INPUT4_BIT);
}

inline void BStop(void){
 cbi(INPUT3_PORT,INPUT3_BIT);
 cbi(INPUT4_PORT,INPUT4_BIT);
}


void PWMA_Set(s16 value){
  if(value==0){
    AStop();
    outp(0,OCR1AH); // highbyte setzen
    outp(0,OCR1AL); // lowbyte setzen
    return;
  }
  if (value<0){
    ABackward();
    value= -value;
  } else AForward();
  
  if (value>511) value=511;
  outp(value>>8,OCR1AH); // highbyte setzen
  outp(value   ,OCR1AL); // lowbyte setzen
}

s16 PWMA_Get(void){
  if(bit_is_set(INPUT1_PORT,INPUT1_BIT)&&bit_is_set(INPUT2_PORT,INPUT2_BIT))
    return 0;
   
  if(bit_is_set(INPUT2_PORT,INPUT2_BIT))
    return  -(inp(OCR1AL)+(inp(OCR1AH)<<8));
   
  if(bit_is_set(INPUT1_PORT,INPUT1_BIT)) 
    return (inp(OCR1AL)+(inp(OCR1AH)<<8));
  
  return 0;
}

void PWMB_Set(s16 value){
  if(value==0){
    BStop();
    outp(0,OCR1AH); // highbyte setzen
    outp(0,OCR1AL); // lowbyte setzen
    return;
  }
  if (value<0) {
    BBackward();
    value= -value;
  } else BForward();
  
  if (value>511) value=511;
  outp(value>>8,OCR1BH);
  outp(value   ,OCR1BL);
}

s16 PWMB_Get(void){
  if(bit_is_set(INPUT3_PORT,INPUT3_BIT)&&bit_is_set(INPUT4_PORT,INPUT4_BIT))
    return 0;
   
  if(bit_is_set(INPUT4_PORT,INPUT4_BIT))
    return  -(inp(OCR1BL)+(inp(OCR1BH)<<8));
   
  if(bit_is_set(INPUT3_PORT,INPUT3_BIT)) 
    return (inp(OCR1BL)+(inp(OCR1BH)<<8));
  
  return 0;
}
