// Real Time Clock

/*
#define mSec(time)	(      ((time.ms)%1000) )
#define Sec(time)	((u08) ((time.ms)/1000) )
#define Min(time)	(      ((time.min)%60)	)
#define Hour(time)	((u08) ((time.min)/60)  )
*/
#define RTC_PRESCALER		(1024)
#define RTC_TICKS_TO_OVERFLOW	(250)
#define	RTC_OVERFLOW_TIME	(64) //((RTC_PRESCALER*RTC_TICKS_TO_OVERFLOW*1000)/F_CPU) //[ms]
#define RTC_START_VAL		(0xff-RTC_TICKS_TO_OVERFLOW)

#define mSec(time)	((u16) ((time)%1000) )
#define Sec(time)	((u08) (((time)/1000)%60) )
#define Min(time)	((u08) (((time)/60000)%60))
#define Hour(time)	((u08) (((time)/3600000)%24))



extern void RTC_Init(void);
extern void UpdateTime(void);
extern t_Time GetmSec(void); // ms
extern t_Time GetSec(void);
extern t_Time GetMin(void);
extern t_Time GetHour(void);
extern t_Time GetTime(void);
extern t_Time SetTime(t_Time t);
extern void RTC_Delay(t_Time ms);
extern u08 RTC_Einschaltverz(u08 bedingung,t_Time verz,t_Time* timevar);
