#include <avr/io.h>
#include <avr/interrupt.h>
#include "global.h"
#include "rtc.h"


/* 
  Real Time Clock using Timer/Counter0
  
*/


volatile t_Time Time;

inline void UpdateTime(void)
{
  Time+=RTC_OVERFLOW_TIME;
}


void RTC_Init(void)
{
	Time=32;
	// Counter Register
	TCNT0=RTC_START_VAL;
	// Overflow enable
	sbi(TIMSK,TOIE0);
	// prescaler select F_CPU/1024
	TCCR0=0x05;
	// ergibt einen overflow alle 32 ms

/*  cbi(TIMSK,TOIE0);
  cbi(TIMSK,OCIE0); 	//Disable TC0 interrupt
  sbi(ASSR,AS0); 			//set Timer/Counter0 to be asynchronous from the CPU clock
  					//with a second external clock(32,768kHz)driving it.
  outp(0,TCNT0);
  outp(0<<PWM2|0<<CS22|1<<CS21|1<<CS20,TCCR0);	//prescale the timer to be clock source / 32 to make it
  					//exactly 1/4 second for every overflow to occur
  while(inp(ASSR)&0x07); 			//Wait until TC0 is updated
  
  sbi(TIMSK,TOIE0); 			//set 8-bit Timer/Counter0 Overflow Interrupt Enable
  sei();
  sbi(DDRB,2);*/
}

inline t_Time GetTime(void)
{
//  return Time+((RTC_START_VAL-TCNT0)*RTC_OVERFLOW_TIME/RTC_TICKS_TO_OVERFLOW);
  return Time+((inp(TCNT0)-5)>>2);
//  return Time;
}

inline t_Time SetTime(t_Time t)
{
  return Time=t;
}
/*
inline t_Time  GetmSec(void) // ms
{
  return Time+(RTC_START_VAL-inp(TCNT0))*RTC_OVERFLOW_TIME/RTC_TICKS_TO_OVERFLOW;
//  return (Time);
}

inline t_Time  GetSec(void)
{
  return (Time/1000);
}

inline t_Time  GetMin(void)
{
  return (Time/60000);
}

inline t_Time  GetHour(void)
{
  return (Time/3600000);
}
*/
void RTC_Delay(t_Time ms)
{
	t_Time	t;
	t=GetTime()+ms;
	while(t>=GetTime());
}

// Einschaltverzgerung
u08 RTC_Einschaltverz(u08 bedingung,t_Time verz,t_Time* timevar)
{
	if(!bedingung)
	{
		*timevar=0;
		return FALSE;
	}
	if(*timevar==0) *timevar=GetTime()+verz;
	if(*timevar<GetTime())
	{
		return TRUE;
	}
	return FALSE;
}

