/*	main.c
*
* 2Do:
*
*
* sollte funzen:
*
* das funzt:
* - LED's ein, aus schalten
* - tasten auslesen
* - pwm ansteuerung
* - beeper mit timer 2 steuern
* - takt auf 4MHz einstellen
* - echtzeituhr ber den timer 0 realisieren
* - sollwerte fr die linensensoren im eeprom (konst array) speichern ?
* - Liniensensoren auslesen
* - Linie verfolgen
*
*/

#include <avr/io.h>
#include <avr/signal.h>
#include <avr/interrupt.h>
//#include <stdio.h>
#include <avr/sleep.h>
#include "global.h"
#include "rtc.h"
#include "adc.h"
//#include "strings.h"
#include "pwm.h"
#include "beep.h"

#define SPEED_GRADEAUS		PWM_MAX
#define SPEED_LANGSAM		200

//PROGRAMM STATII
#define STATE_STEHEN		0
#define STATE_RUMFAHREN		1
#define	STATE_WAIT_UP		2
#define	STATE_WAIT_UP_L		3
#define	STATE_WAIT_UP_R		4
#define STATE_FOLGEN		10

#define TEACH_IN		100
#define TEACH_WAIT		101
#define TEACH_OUT		109

#define TEACH_LEFT		110
#define TEACH_LEFT2		111
#define TEACH_CENTER		112
#define TEACH_CENTER2		113
#define TEACH_RIGHT		114
#define TEACH_RIGHT2		115

#define UARTOUT

#ifdef UARTOUT
#include <avr/pgmspace.h>
#include "uart.h"
#endif
//typedef short t_Sensors[6];

s16 sollL[6],sollR[6];
s16 ist[6];


/*-------------Initalisierung------------------*/
/*
* type: art der daten
* 0:istwerte
* 1:linke sollwerte
* 2:mittlere sollwerte
* 3:rechte sollwerte
*/
#ifdef UARTOUT
void SendSensors(s16 sens[6],u08 type)
{
	u08 i;
	u16 data;
	if(UART_ReadyTx||type||UART_GetDataLength()<5)
	{
		UART_SendByte(0xff);
		UART_SendByte(0xff-type);
		for(i=0;i<6;i++)
		{
			data=sens[i];
			UART_SendByte(data>>8);
			data=sens[i];
			UART_SendByte(data&0x00ff);
		}
	}
	
}
#endif

void init(void){
// uart
#ifdef UARTOUT
  UART_Init();
  UART_PRINT("UART ready");
  UART_EOL();
#endif
  // Krachmacher
  Beep_Init();
  Beep_SetFreq(1000);

  // Motorsteuerung
  PWM_Init();
 
  // Analog Digital Wandler
  ADC_Init();
  sbi(ACSR,ACD);// analog comparator ausschalten

  // Echtzeituhr
  RTC_Init();
    
  // pull up fr tasten
  cbi(DDRB,4);
  sbi(PORTB,4); // links
  cbi(DDRD,3);
  sbi(PORTD,3); // mitte (int1)
  cbi(DDRD,4);
  sbi(PORTD,4); // rechts

  // led's
  LEDS_OFF;
  sbi(DDRB,5); // ausgang
  
  // akku signal pin
  BAT_SIG_OFF;
  BAT_SET_IN;


//  ReadKonst(0);
  sei(); // interupt enable
  
  Beep(400,50);
  Beep(600,50);
  Beep(800,50);
  Beep(1000,50);

}// init end

void GoSleeping(void)
{
	TCCR1A=0;
	TCCR1B=0;
	TCCR2=0;
	ADCSR=0;

	PORTB=0; 
	PORTC=0;
	PORTD=0;
	sbi(PORTD,3);//INT1
	// power down mode
	MCUCR=1<<SE|0<<SM2|1<<SM1|0<<SM0|0<<ISC11|0<<ISC10;
	sbi(GICR,INT1);
	sleep_mode();
	cbi(GICR,INT1);
	MCUCR=0;
	init();
}


/*----------------Timer Interrupts--------------------*/

// alle 32ms
SIGNAL(SIG_OVERFLOW0)
{
	TCNT0=RTC_START_VAL;
	UpdateTime();
}

/*----------------------------------------------------*/

/*----------------External Interrupts--------------------*/

SIGNAL(SIG_INTERRUPT1)
{
//	Beep(100,300);
	asm("nop");
}

/*----------------------------------------------------*/


void ReadSensors(s16* sens)
{
//    LEDS_ON;
    sens[5]=LINIE6;
    sens[0]=LINIE1;
    sens[2]=LINIE3;
    sens[4]=LINIE5;
    sens[1]=LINIE2;
    sens[3]=LINIE4;
//    LEDS_OFF;
}

void SaveSensors(s16* sens,u16 addr)
{
	u08 i;
	for(i=0;i<6;i++) konst[i+addr]=sens[i];
}

void LoadSensors(s16* sens,u16 addr)
{
	u08 i;
	for(i=0;i<6;i++) sens[i]=konst[i+addr];
}
/*
// differenz zwischen zwei sensor daten ermitteln
u16 SensorDif(t_Sensors *sens1,t_Sensors *sens2)
{
	u08 i;
	u16 result;
	result=0;
	for(i=0;i<6;i++)
	{
		result+=ABS((*sens1[i])-(*sens2[i]));
	}
	return result;
}
*/
void FolgeLinie(void)
{
      	u16 difL,difR;
      	u16 difsum; // summe aller differenzen
      	s16 motorL,motorR;
      	u08 i;
	
      	ReadSensors(ist);
	difL=0;
	difR=0;
	for(i=0;i<6;i++)
	{
		difL+=ABS(ist[i]-sollL[i])>>2;
		difR+=ABS(ist[i]-sollR[i])>>2;
	}
	difsum=difR+difL;
	motorL=10 - ((20*difR)/difsum) + ((20*difL)/difsum);
	motorR=10 - ((20*difL)/difsum) + ((20*difR)/difsum);

	PWMA_Set(motorL*52);
	PWMB_Set(motorR*52);

}

/*---------------Main Loop---------------------------*/
int main(void){
  u08 state=STATE_STEHEN;
  t_Time t1=0,t2=0;

  ReadKonst(0);
  LoadSensors(sollL,0);
  LoadSensors(sollR,6);
  init();

 
  for(EVER)
  {
        
    // rumfahren
    switch (state) 
    {

      case STATE_STEHEN:
      	if(GetTime()%1000<5) 
     	{
  	      	LEDS_ON;
	}
      	else LEDS_OFF;
        PWMA_Set(0);
        PWMB_Set(0);
	if(RTC_Einschaltverz(TASTE_M,1000,&t1))
	{
		t1=0;
		state=TEACH_IN;
	      	Beep(500,300);
      		Beep(2000,100);
      	}
      	if(TASTE_R) state=STATE_WAIT_UP_R;
      	if(TASTE_L) state=STATE_WAIT_UP_L;

	if(RTC_Einschaltverz(!TASTE,30000,&t2))
	{
		t2=0;
		Beep(5000,100);
		GoSleeping();
      	}

      break;
      
      case STATE_WAIT_UP:
        PWMA_Set(0);
        PWMB_Set(0);
        RTC_Delay(30);
      	if(!TASTE) state=STATE_STEHEN;
      break;

      case STATE_WAIT_UP_L:
  	LEDS_ON;
	#ifdef UARTOUT
    	SendSensors(sollL,1);
    	SendSensors(sollR,3);
    	t2=0;
	#endif
        RTC_Delay(30);
      	if(!TASTE_L) state=STATE_FOLGEN;
      break;
      
      case STATE_WAIT_UP_R:
        #ifdef UARTOUT
        t2=0;
        #endif
        RTC_Delay(30);
      	if(!TASTE) state=STATE_RUMFAHREN;
      break;

      case STATE_RUMFAHREN:
     	LEDS_OFF;
        SET_MOTOR_L(PWM_MAX);
        SET_MOTOR_R(PWM_MAX);
        Beep(500,20);
        RTC_Delay(50);
      	if(TASTE) state=STATE_WAIT_UP;
      break;

      case STATE_FOLGEN:
      	FolgeLinie();
	#ifdef UARTOUT
    	SendSensors(ist,0);
	if(RTC_Einschaltverz(TRUE,15000,&t2))
	{
		t2=0;
	    	SendSensors(sollL,1);
    		SendSensors(sollR,3);
      	}
	#endif

      	if(RTC_Einschaltverz(TASTE,10,&t1)) state=STATE_WAIT_UP;
      break;

      case TEACH_IN:
      	RTC_Delay(30);
      	if(!TASTE_M) state=TEACH_WAIT;
      break;

      case TEACH_WAIT:
      	t1=0;
      	if(GetTime()%300<5) LEDS_ON;
      	else LEDS_OFF;
      	if(TASTE_L) state=TEACH_LEFT;
      	if(TASTE_M) state=TEACH_CENTER;
      	if(TASTE_R) state=TEACH_RIGHT;
      	if(TASTE) LEDS_OFF;
      break;

      case TEACH_OUT:
      	LEDS_OFF;
	if(!TASTE_M) state=STATE_STEHEN;
      break;

      case TEACH_LEFT:
        LEDS_ON;
      	RTC_Delay(30);
      	if (!TASTE_L) state=TEACH_LEFT2;
      break;

      case TEACH_LEFT2:
      	// einlesen
      	ReadSensors(sollL);
	#ifdef UARTOUT
    	SendSensors(sollL,1);
	#endif
      	Beep(600,200);
      	state=TEACH_WAIT;
      break;

      case TEACH_CENTER:
      	RTC_Delay(30);
    	LEDS_ON;
      	if(!TASTE_M) state=TEACH_CENTER2;
      	if(RTC_Einschaltverz(TASTE_M,1000,&t1))
      	{
      		t1=0;
      		state=TEACH_OUT;
	      	Beep(2000,100);
      		Beep(500,300);
      		// Werte speichern
      		SaveSensors(sollL,0);
      		SaveSensors(sollR,6);
 		SaveKonst(0);
      	}
      break;

      case TEACH_CENTER2:
      	// einlesen
      	Beep(800,200);
      	state=TEACH_WAIT;
      break;

      case TEACH_RIGHT:
        LEDS_ON;
      	RTC_Delay(30);
      	if (!TASTE_R) state=TEACH_RIGHT2;
      break;
      
      case TEACH_RIGHT2:
      	// einlesen
      	ReadSensors(sollR);
	#ifdef UARTOUT
    	SendSensors(sollR,3);
    	#endif
      	Beep(1000,200);
      	state=TEACH_WAIT;
      break;
      
      default: state = STATE_STEHEN; break;
    }//switch
  
  }// for
}// main
