
//*****************************************************************************
//
// File Name	: 'uart.h'
// Title			: UART driver with buffer support
// Author		: Pascal Stang - Copyright (C) 2000-2002
// Created		: 11/22/2000
// Revised		: 11/01/2001
// Version		: 1.3
// Target MCU	: ATMEL AVR Series
// Editor Tabs	: 3
//
// This code is distributed under the GNU Public License
//		which can be found at http://www.gnu.org/licenses/gpl.txt
//
//*****************************************************************************

#ifndef UART_H
#define UART_H

#include "global.h"
#include "buffer.h"

// default baud rate
// can be changed by using uartSetBaudRate()
#define UART_BAUD_RATE				57600

// buffer memory allocation defines
// buffer sizes
#define UART_TX_BUFFER_SIZE		0x0055
#define UART_RX_BUFFER_SIZE		0x0015

// define this key if you wish to use
// external RAM for the	UART buffers
//#define UART_BUFFERS_EXTERNAL_RAM

#ifdef UART_BUFFERS_EXTERNAL_RAM
	// address of uart buffers
	#define UART_TX_BUFFER_ADDR		0x1100
	#define UART_RX_BUFFER_ADDR		0x1200
#endif

// compatibility with dual-uart processors
// (if you need to use both uarts, please use the uart2 library)
#ifdef UDR0
	#define UDR					UDR0
	#define UBRR				UBRR0L
	#define SIG_UART_TRANS	SIG_UART0_TRANS
	#define SIG_UART_RECV	SIG_UART0_RECV
	#define SIG_UART_DATA	SIG_UART0_DATA
#endif
// compatibility for the mega161
#ifndef RXCIE
	#define RXCIE	RXCIE0
	#define TXCIE	TXCIE0
	#define UDRIE	UDRIE0
	#define RXEN	RXEN0
	#define TXEN	TXEN0
	#define CHR9	CHR90
	#define RXB8	RXB80
	#define TXB8	TXB80
#endif

#ifndef UBRR0L
	#define UBRR0L	UBRR0
	#define UBRR1L	UBRR1
#endif


#define UART_rxd	!UART_ReceiveBufferIsEmpty
#define UART_PRINT(s)	(UART_PrintfProgStr(PSTR(s)))
#define UART_EOL	UART_PrintfEndOfLine
extern volatile u08   UART_ReadyTx; 

// functions

// initializes transmit and receive buffers
// called from uartInit()
void UART_InitBuffers(void);

// initializes uart
void UART_Init(void);

// sets the uart baud rate
void UART_SetBaudRate(u16 baudrate);

// returns pointer to the receive buffer structure
cBuffer* UART_GetRxBuffer(void);

// returns pointer to the transmit buffer structure
cBuffer* UART_GetTxBuffer(void);

// sends a single byte over the uart
void UART_SendByte(u08 data);

// gets a single byte from the uart receive buffer
// function returns TRUE if data was available, FALSE if not
// actual data is returned in variable pointed to by "data"
// example usage:
// char myReceivedByte;
// uartReceiveByte( &myReceivedByte );
u08 UART_ReceiveByte(void);

// returns TRUE/FALSE if receive buffer is empty/not-empty
u08 UART_ReceiveBufferIsEmpty(void);

// flushes (deletes) all data from receive buffer
void UART_FlushReceiveBuffer(void);

// begins transmission of the transmit buffer under interrupt control
//void UART_SendTxBuffer(void);

// sends a buffer of length nBytes via the uart using interrupt control
u08  UART_SendBuffer(char *buffer, u16 nBytes);

void UART_PrintStr(u08 s[]);
void UART_PrintfProgStr(u08* pBuf);
void UART_PrintfEndOfLine(void);
u16 UART_GetDataLength(void);
void UART_PrintInt(long i);


#endif

