/*
* von Maximilian Laiacker mlaiacker@gmx.de
* http://der-max.no-ip.org
*/

#include <avr/io.h>
#include <avr/interrupt.h>
#include "rtc.h"


/* 
  Real Time Clock using Timer/Counter0
*/


volatile t_Time Time;

/* wird vom interrupt aufgerufen */
inline void rtcInt(void)
{
  TCNT0=RTC_START_VAL;
  Time+=RTC_OVERFLOW_TIME;
}


void rtcInit(void)
{
	Time=0;
	// Counter Register
	TCNT0=RTC_START_VAL;
	// Overflow enable
	sbi(TIMSK,TOIE0);
	// prescaler select F_CPU/1024
	TCCR0=0x05;
	// ergibt einen overflow alle 32 ms

}

/* gibt die Zeit in ms zurck */
t_Time rtcGetTime(void)
{
//  return Time+((RTC_START_VAL-TCNT0)*RTC_OVERFLOW_TIME/RTC_TICKS_TO_OVERFLOW);
  return Time+((inp(TCNT0)-5)>>3);
//  return Time;
}

t_Time rtcSetTime(t_Time t)
{
  return Time=t;
}

void rtcDelay(t_Time ms)
{
	t_Time	t;
	t=rtcGetTime()+ms;
	while(t>=rtcGetTime());
}

// Einschaltverzgerung
unsigned char rtcEinschaltverz(unsigned char bedingung,t_Time verz,t_Time* timevar)
{
	if(!bedingung)
	{
		*timevar=0;
		return 0;
	}
	if(*timevar==0) *timevar=rtcGetTime()+verz;
	if(*timevar<=rtcGetTime())
	{
		return -1;
	}
	return 0;
}

// Ausschaltverzgerung
unsigned char rtcAusschaltverz(unsigned char bedingung,t_Time verz,t_Time* timevar)
{
	if(bedingung)
	{
		*timevar=0;
		return -1;
	}
	if(*timevar==0) *timevar=rtcGetTime()+verz;
	if(*timevar<=rtcGetTime())
	{
		return 0;
	}
	return -1;
}

// wird wenn "bedingung" "verz" ms wahr war fr einen aufruf wahr
unsigned char rtcImpulsverz(unsigned char bedingung,t_Time verz,t_Time* timevar)
{
	if(!bedingung)
	{
		*timevar=0;
		return 0;
	}
	if(*timevar==0) *timevar=rtcGetTime()+verz;
	if(*timevar<=rtcGetTime())
	{
		*timevar = 0;
		return -1;
	}
	return 0;
}
