#include <avr/io.h>
#include "global.h"
#include "beep.h"
#include "rtc.h" // fr pause bei Beep() wenn nicht vorhanden, selber delay Funktion schreiben

/* Beeper using Timer/Counter2 */

void Beep_Init(void){
	//Set timer/counter2 to CTC Mode
	sbi(TCCR2,WGM21);
	cbi(TCCR2,WGM20);
	//toggle output on each compare
	sbi(TCCR2,COM20);
	cbi(TCCR2,COM21);
	//set ddr
	sbi(DDRB,3);
	//initially turn off timer
	Beep_SetFreq(0);
}

void Beep_SetFreq(u32 freq)
{
	u08 x=0;
	u32 ocr2=0;
	u16 n[7]={1,8,32,64,128,256,1024};
	if(freq<=0)
	{
		// turn off timer
		TCCR2=(TCCR2&0xf8);
		return;
	}
/* ocr2 wert suchen */
    	ocr2=F_CPU/(2*freq*n[x])-1;
	while(ocr2>255)
	{
		x++;
		if(x>7)
		{
			// frequenz zu klein
			// timer off
			TCCR2=(TCCR2&0xf8);
			return;
		}
		ocr2=F_CPU/(2*freq*n[x])-1;
	}
	// set registers
	 OCR2=ocr2;
	 TCCR2=(TCCR2&0xf8)|(x+1);
}

void Beep(u32 freq,t_Time delay)
{
	Beep_SetFreq(freq);
	RTC_Delay(delay);
	Beep_SetFreq(0);
}
