#include <avr/io.h>
#include <avr/signal.h>
#include <avr/interrupt.h>
#include "global.h"
#include "ADC.h"


void ADC_Init(void){
  outp(1<<ADEN|0<<ADIE|0<<ADIF|1<<ADPS2|0<<ADPS1|0<<ADPS0,ADCSRA);
  sbi(ADMUX,REFS0);
}

u16 AD(u08 x){
  u16 result;
  ADMUX = (ADMUX & 0xF0) | x;
  sbi(ADCSRA,ADSC);
  while (bit_is_set(ADCSRA,ADSC));
  
  result=inp(ADCL);
  result+=inp(ADCH)<<8;
  return result;
}
