/*	Sumo main.c
*
* 2Do:
* - Liniensensoren
* - neue Platine
*
*
* sollte funzen:
* - 
* - 
*
* das funzt:
* - hardware bauen
* - Ir Decoding
*
*/

#include <avr/io.h>
#include <avr/pgmspace.h>
#include <avr/signal.h>
#include <avr/interrupt.h>
#include <stdio.h>
#include <avr/sleep.h>
//#include <math.h>
#include "global.h"
#include "rtc.h"
#include "adc.h"
#include "uart.h"
#include "pwm.h"
#include "beep.h"
#include "ir_codes.h"
#include "konst.h"

#define SPEED_GRADEAUS		PWM_MAX
#define SPEED_LANGSAM		(200)
#define SPEED_IR		(58*speed)
#define SPEED_DREH_VORWAERTS	(450)
#define SPEED_DREH_RUECKWAERTS	(-PWM_MAX)

#define SPEED_RINGEN		(300)
#define TIME_DREHEN		(200) //ms
#define RAND_VALUE		(500)

#define SUMO_WAIT		(5100)

#define SPEED_WEICHEN		(400)
#define BODEN_N			(10)  // wie oft bodensensoren ausgelesen werden

#define WAND_SOLLL		(750) // fr wandverfolgung 750
#define WAND_SOLLM		(950) // fr wandverfolgung 950

#define WAND_SOLLL2		(750)

#define WAND_SOLLL3		(750)

 
//PROGRAMM STATII
#define STATE_DO_NOTHING	0
#define STATE_STEHEN		1
#define STATE_5S_WARTEN		2
#define STATE_LINKS_DREHEN	3
#define STATE_RECHTS_DREHEN	4
#define STATE_GERADEAUS		5
#define STATE_RUECKWAERTS	6
#define STATE_VIEW		7

#define STATE_RINGEN		10
#define STATE_WEICHEN		20
#define STATE_WAND		30
#define STATE_WAND2		40
#define STATE_WAND3		50
#define STATE_LINIE		60
#define STATE_LINIE_KKF		70
#define STATE_LINIE2		80

#define RINGEN_STATE_RINGEN	10
#define RINGEN_STATE_RAND_L	11
#define RINGEN_STATE_RAND_R	12


// inputs
#define START		(bit_is_clear(PINA,4))

#define BODEN_R		(AD(7))
#define BODEN_L		(AD(6))
#define RAND_R		BODEN_R
#define RAND_L		BODEN_L
#define SHARP_LL	(1023-AD(0)) 
#define SHARP_L		(1023-AD(1)) //l
#define SHARP_M		(1023-AD(2)) //m
#define SHARP_R		(1023-AD(3)) //r

// outputs
#define IR_LED_ON	(sbi(PORTD,6))
#define IR_LED_OFF	(cbi(PORTD,6))
#define RED_LEDS_ON	(sbi(PORTB,0))
#define RED_LEDS_OFF	(cbi(PORTB,0))

#define MOTOR_L(x)	(PWMA_Set(x))
#define MOTOR_R(x)	(PWMB_Set(x))

// konst
#define SENSORS		8 // wie viele inputs
// von links nach rechts
#define LINIE0		(RAND_L)
#define LINIE1		(AD(0))
#define LINIE2		(AD(1))
#define LINIE3		(AD(2))
#define LINIE4		(AD(3))
#define LINIE5		(AD(4))
#define LINIE6		(AD(5))
#define LINIE7		(RAND_R)


#define BODEN_L_SCHLECHT	konst[0]
#define BODEN_R_SCHLECHT	konst[1]
#define BODEN_L_GUT			konst[2]
#define BODEN_R_GUT			konst[3]

s16 ist[SENSORS],tmp_data[SENSORS];


u08 ir_state,ir_count=0,ir_up,ir_tcnt,ir_bit;
u32 ir_data;
t_Time ir_timer,ir_dif;
//u08 s[0xff];
u16 ir_buf[10];

s16 speed=0;
/*-------------Initalisierung------------------*/
/*
* type: art der daten
* 0:istwerte
* 1:linke sollwerte
* 2:mittlere sollwerte
* 3:rechte sollwerte
*/
void sensorsSend(s16* sens,u08 type)
{
	u08 i;
	u16 data;
	if(UART_ReadyTx||type||UART_GetDataLength()<5)
	{
		UART_SendByte(0xff);
		UART_SendByte(0xff-type);
		for(i=0;i<6;i++)
		{
			data=sens[i];
			UART_SendByte(data>>8);
			data=sens[i];
			UART_SendByte(data&0x00ff);
		}
	}
	
}

void init(void){
// uart
  UART_Init();
  UART_PRINT("UART ready");
  UART_EOL();
  // Krachmacher
  Beep_Init();
  Beep_SetFreq(1000);

  // Motorsteuerung
  PWM_Init();
 
  // Analog Digital Wandler
  ADC_Init();
  sbi(ACSR,ACD);// analog comparator ausschalten

  // Echtzeituhr
  RTC_Init();
    
  // pull up
//  sbi(PORTB,0);// Start
  sbi(PORTB,1);// Stop
  sbi(PORTD,2);// IR Daten
  //DDR
  sbi(DDRD,6); // IR_LED
  sbi(DDRB,0);
  IR_LED_ON;
  
  // INT0 bei flanke
  cbi(MCUCR,ISC01);
  sbi(MCUCR,ISC00);
  sbi(GICR,INT0);
  sei(); // interupt enable

// start
  cbi(DDRA,4);
  sbi(PORTA,4);
  sbi(DDRA,5);
  cbi(PORTA,5);
  Beep(400,50);
  Beep(600,50);
  Beep(800,50);
  Beep(1000,50);

}// init end


/*----------------Timer Interrupts--------------------*/

// alle 32ms
SIGNAL(SIG_OVERFLOW0)
{
	UpdateTime();
	ir_timer+=RTC_TICKS_TO_OVERFLOW;
}

/*----------------------------------------------------*/

/*----------------External Interrupts-----------------*/
// IR Int
SIGNAL(SIG_INTERRUPT0)
{
	ir_dif=((TCNT0-RTC_START_VAL)-ir_tcnt)+ir_timer;
	ir_tcnt=(TCNT0-RTC_START_VAL);
	ir_timer=0;
	if((ir_dif>=3)&&(ir_dif<=35))
	{
		if(ir_dif>9) ir_data |= (1<<ir_bit);
		if(((ir_bit++)>=16)&&(ir_count<10))
		{
			ir_buf[ir_count++]=ir_data;
			ir_bit=0;
			ir_data=0;
		}
	}else
	{
		ir_bit=0;
		ir_data=0;
	}
}

/*----------------------------------------------------*/
void sensorsRead(s16* sens)
{
//    RED_LEDS_ON;
    sens[7]=LINIE7;
    sens[0]=LINIE0;
    sens[6]=LINIE6;
    sens[1]=LINIE1;
    sens[3]=LINIE3;
    sens[5]=LINIE5;
    sens[2]=LINIE2;
    sens[4]=LINIE4;
//    RED_LEDS_OFF;
}

void bodenRead(s16 *bodenL,s16 *bodenR)
{
	u08 i;
	*bodenL = 0;
	*bodenR = 0;
	for (i=0;i<BODEN_N;i++) 
	{
		*bodenL += RAND_L;
		*bodenR += RAND_R;
	}
	*bodenL /= BODEN_N;
	*bodenR /= BODEN_N;
}

s16 nur_positiv(s16 x)
{
	if(x>0) return x; 
	else return 0;
}

s16 abs(s16 x)
{
	if(x<0) return -x; 
	else return x;
}

s16 min(s16 x, s16 y)
{
	if(x<y) return x; else return y;
}

s16 max(s16 x, s16 y)
{
	if(x>y) return x; else return y;
}

u08 bodenSchlecht(s16 ist, s16 gut, s16 schlecht)
{
	return (abs(ist-schlecht)<abs(ist-gut));
/*	if(gut<schlecht)
	{
		return (ist>=schlecht);
	}
	else
	{
		return (ist<=schlecht);
	}*/
}

/*----------------Main Loop---------------------------*/
int main(void){
  u08 state=STATE_STEHEN;
  u08 ringenState=RINGEN_STATE_RINGEN;
  t_Time t1=0,t2=0,t3=0,t4=0;
  u08 i;
  u08 j;
  u16 bodenL=0, bodenR=0;
  s16 difflr=0, difflr_max=0, sharp_m_max=0, sharp_m_min=1023, sharp_m=0;
  s16 sl=0;
  u16 blinker = 0;
  s16 tmp=0;
  s32 tmp32=0;
  u08 schlechtL,schlechtR;

  konstRead(0);

  init();

 
  for(;;)
  {
   	j=ir_count;
    	for(i=0;i<ir_count-1;i++)
    	{
    		if(ir_buf[i]==0x5545)
    		{
	      	  	Beep_SetFreq(0);
	      	  	t2 = 0;
	    		switch(ir_buf[i+1])
    			{
    			case IR_UP: state = STATE_GERADEAUS; break;
    			case IR_DOWN: state = STATE_RUECKWAERTS; break;
    			case IR_LEFT: state = STATE_LINKS_DREHEN; break;
    			case IR_RIGHT: state = STATE_RECHTS_DREHEN; break;
    			case IR_STOP: state = STATE_STEHEN; break;
    			case IR_1:speed=1;Beep(100,100);break;
    			case IR_2:speed=2;Beep(200,100);break;
    			case IR_3:speed=3;Beep(300,100);break;
    			case IR_4:speed=4;Beep(400,100);break;
    			case IR_5:speed=5;Beep(500,100);break;
    			case IR_6:speed=6;Beep(600,100);break;
    			case IR_7:speed=7;Beep(700,100);break;
    			case IR_8:speed=8;Beep(800,100);break;
    			case IR_9:speed=9;Beep(900,100);break;
    			case IR_0:speed=0;Beep(1000,100);break;
    			case IR_SEARCH: state = STATE_5S_WARTEN; break;
    			case IR_KARAOKE: state = STATE_WEICHEN; break; 
    			case IR_RAND: state = STATE_WAND; break;
    			case IR_SURROUND: state = STATE_WAND2; break;
    			case IR_L_R: state = STATE_WAND3; break;
    			case IR_EJECT: state = STATE_LINIE; break;
    			case IR_RETURN: state = STATE_LINIE2; break;
    			case IR_PREV:Beep( 600,200); break;
    			case IR_NEXT:Beep(1000,200); break;
    			case IR_VIEW: state = STATE_VIEW; Beep(440,200); break;
    			case IR_PROG: konstSave(0); Beep(2000,100);	Beep(500,300); break;
				case IR_RESUME: Beep(100,100); Beep(1000,100); break;
				case IR_10_PLUS:Beep(4000,100); break;
    			case IR_OSD:bodenRead(&BODEN_L_SCHLECHT,&BODEN_R_SCHLECHT);Beep( 600,200); break;
    			case IR_PBC:bodenRead(&BODEN_L_GUT,&BODEN_R_GUT);Beep(1000,200); break;
			}
		   	ir_count=0;
	    	}
	}
	if(ir_count>=10) ir_count=0;
	if(START)	
	{	
		state = STATE_5S_WARTEN;
		t2=0;
	}
	
       
    // rumfahren
	switch (state) 
    {
		case STATE_DO_NOTHING:
      	break;

		case STATE_STEHEN:
			RED_LEDS_OFF;
			MOTOR_L(0);MOTOR_R(0);
			IR_LED_OFF;
			RED_LEDS_OFF;
			t2 = 0;
		state = STATE_DO_NOTHING;
		break;
      	
      	case STATE_GERADEAUS:
			MOTOR_L(SPEED_IR);MOTOR_R(SPEED_IR);
			state = STATE_DO_NOTHING;
		break;
      	
      	case STATE_RUECKWAERTS:
			MOTOR_L(-SPEED_IR);MOTOR_R(-SPEED_IR);
			state = STATE_DO_NOTHING;
		break;
      	
      	case STATE_LINKS_DREHEN:
      	  MOTOR_L(-SPEED_IR);MOTOR_R(SPEED_IR);
      	  state = STATE_DO_NOTHING;
      	break;
      	
      	case STATE_RECHTS_DREHEN:
      	  MOTOR_L(SPEED_IR);MOTOR_R(-SPEED_IR);
      	  state = STATE_DO_NOTHING;
      	break;
      
      	case STATE_5S_WARTEN:
			MOTOR_L(0);
			MOTOR_R(0);
			Beep_SetFreq(GetTime() - t2 + SUMO_WAIT);
			if(se(TRUE,SUMO_WAIT,&t2))
			{
				state=STATE_RINGEN;
				t2=0;
				t1=0;
				blinker = 0;
				Beep_SetFreq(0);
				ringenState=RINGEN_STATE_RINGEN;
				break;
			}
			if(se(TRUE,blinker,&t1))
			{
				if(bit_is_set(PORTD,6)) IR_LED_OFF;
				else IR_LED_ON;
				t1=0;
				blinker = (t2 - GetTime())/5;
			}
		break;
      
     	case STATE_RINGEN:
			RED_LEDS_ON;
			bodenL=BODEN_L;
			bodenR=BODEN_R;
			schlechtL=bodenSchlecht(bodenL,BODEN_L_GUT,BODEN_L_SCHLECHT);
			schlechtR=bodenSchlecht(bodenR,BODEN_R_GUT,BODEN_R_SCHLECHT);
			// Schranken-Werte bestimmen und ausgeben
			sharp_m=SHARP_M;
			if (sharp_m_min>sharp_m)
			{
				sharp_m_min=sharp_m;
			} else if (sharp_m_max<sharp_m)
			{
				sharp_m_max=sharp_m;
			}
			
			//difflr = pow(SHARP_L, 1.1) - pow(SHARP_R, 1.1);
			difflr = SHARP_L - SHARP_R;
			if (difflr_max<abs(difflr))
			{
				difflr_max = abs(difflr);
			}
			  
			switch (ringenState)
			{
				case RINGEN_STATE_RINGEN:
				  if (rtcImpulsverz(schlechtL, 10, &t1)) ringenState = RINGEN_STATE_RAND_L;
				  else
				  if (rtcImpulsverz(schlechtR, 10, &t2)) ringenState = RINGEN_STATE_RAND_R;
				  else
				  {
					MOTOR_L(difflr*50/(difflr_max/20) + (sharp_m_max-sharp_m)*30/((sharp_m_max-sharp_m_min)/20) + SPEED_RINGEN);
					MOTOR_R((-difflr*50)/(difflr_max/20) + (sharp_m_max-sharp_m)*30/((sharp_m_max-sharp_m_min)/20) + SPEED_RINGEN);
//					MOTOR_L((difflr*20)/(difflr_max/40) + (sharp_m_max-sharp_m)*20/((sharp_m_max-sharp_m_min)/30)*3 + SPEED_RINGEN);
//					MOTOR_R((-difflr*20)/(difflr_max/40) + (sharp_m_max-sharp_m)*20/((sharp_m_max-sharp_m_min)/30)*3 + SPEED_RINGEN);
				  }
				  break;
				case RINGEN_STATE_RAND_L:
				  MOTOR_L(SPEED_DREH_VORWAERTS);
				  MOTOR_R(SPEED_DREH_RUECKWAERTS);
				  if (!sa(schlechtL, TIME_DREHEN, &t3))
				  {
					ringenState = RINGEN_STATE_RINGEN;
					t3=0;
				  }
				break;
				case RINGEN_STATE_RAND_R:
				  MOTOR_L(SPEED_DREH_RUECKWAERTS);
				  MOTOR_R(SPEED_DREH_VORWAERTS);
				  if (!sa(schlechtR, TIME_DREHEN, &t4))
				  {
					ringenState = RINGEN_STATE_RINGEN;
					t4=0;
				  }
				break;
			}
		break;
	  
		case STATE_WEICHEN:// (KARAOKE)
			difflr = (sharp_m_max-sharp_m)*difflr*4/(sharp_m_max-sharp_m_min) + difflr;
			MOTOR_R(difflr*41/(difflr_max/20) + SPEED_WEICHEN);
			MOTOR_L((-difflr*41)/(difflr_max/20) + SPEED_WEICHEN);
		break;
			  
		case STATE_WAND: // aussenwand lang (RAND)
			sl = SHARP_L;
			MOTOR_L((WAND_SOLLL - sl) + 511 + nur_positiv(WAND_SOLLM - SHARP_M)*4);
			MOTOR_R((sl - WAND_SOLLL) + 511 - nur_positiv(WAND_SOLLM - SHARP_M)*4);
		break;
	
		case STATE_WAND2: // an der innenwand lang (SURROUND)
			sl = SHARP_R;
			MOTOR_R((WAND_SOLLL2 - sl)*11/10 + 511 );
			MOTOR_L((sl - WAND_SOLLL2)*11/8 + 511 );
		break;
	
		case STATE_WAND3: // aussenwand lang (L_R)
			sl = min(SHARP_L, SHARP_LL-170);
			MOTOR_L((WAND_SOLLL3 - sl)*2 + 511 + nur_positiv(WAND_SOLLM - SHARP_M)*4);
			MOTOR_R((sl - WAND_SOLLL3)*2 + 511 - nur_positiv(WAND_SOLLM - SHARP_M)*4);
		break;
			
		case STATE_VIEW:
			RED_LEDS_ON;
			sharp_m=SHARP_M;
			if (sharp_m_min>sharp_m)
			{
				sharp_m_min=sharp_m;
			} else if (sharp_m_max<sharp_m)
			{
				sharp_m_max=sharp_m;
			}
			
			//difflr = pow(SHARP_L, 1.1) - pow(SHARP_R, 1.1);
			difflr = -(s16)SHARP_L + (s16)SHARP_R;
			if (difflr_max<abs(difflr))
			{
				difflr_max = abs(difflr);
			}
			  

			sensorsRead(ist);
			ist[0]=(difflr*50/(difflr_max/20) + (sharp_m_max-sharp_m)*30/((sharp_m_max-sharp_m_min)/20) + SPEED_RINGEN)+512;
			ist[5]=((-difflr*50)/(difflr_max/20) + (sharp_m_max-sharp_m)*30/((sharp_m_max-sharp_m_min)/20) + SPEED_RINGEN)+512;
			
			sensorsSend(ist,0);
			if(bodenSchlecht(BODEN_L,BODEN_L_GUT,BODEN_L_SCHLECHT)||bodenSchlecht(BODEN_R,BODEN_R_GUT,BODEN_R_SCHLECHT)) IR_LED_ON; else IR_LED_OFF;
			if(RTC_Einschaltverz(TRUE,500,&t2))
			{
				t2=0;
				for(i=0;i<SENSORS;i++)ist[i]=0;
				ist[0]=difflr+512;
				ist[1]=BODEN_L_SCHLECHT;
				ist[2]=BODEN_R_GUT;
				ist[3]=BODEN_R_SCHLECHT;
				ist[4]=BODEN_L;
				ist[5]=BODEN_R;
				sensorsSend(ist,2);
			}
		break;
			
		case STATE_LINIE:
		break;
		
		case STATE_LINIE_KKF:
		break;
#define LINIE_BLACK		(700)
		case STATE_LINIE2: // linie sollte immer unter dem sensor 1 (zweiter von links) sein (IR_RETURN)
			RED_LEDS_ON;
	      	sensorsRead(ist);
			tmp=- nur_positiv(ist[1]-LINIE_BLACK)*3 
				- nur_positiv(ist[2]-LINIE_BLACK)*6 
				- nur_positiv(ist[3]-LINIE_BLACK)*8 
				- nur_positiv(ist[4]-LINIE_BLACK)*10 
				- nur_positiv(ist[5]-LINIE_BLACK)*12 
				- nur_positiv(ist[6]-LINIE_BLACK)*14 
				- nur_positiv(ist[7]-LINIE_BLACK)*16 
				+ nur_positiv(ist[0]-LINIE_BLACK)*32;
				
			if(rtcImpulsverz(1,5,&t2))
			{
				if((ist[1]<LINIE_BLACK)&&(tmp>(-300))) 
				{
					if(tmp32<(speed*100 -tmp+200)) tmp32++;
				} else 
				{
					if(tmp32>0) tmp32=0;
				}
			} 
			tmp+=tmp32;
			MOTOR_L(speed*100 -tmp);
			MOTOR_R(speed*100 +tmp);
			if(PWMA_Get()<500) IR_LED_OFF; else IR_LED_ON;
		break;
			  
		default: state = STATE_STEHEN; break;
    }//switch
  }// for ever
}// main

