#include <avr/io.h>
#include "global.h"
#include "PWM.h"



void PWM_Init(void){
 // Cleared on compare match, up-counting. Set on compare match, down-counting (non-inverted PWM). 9Bit PWM
 outp(1<<COM1A1|0<<COM1A0|1<<COM1B1|0<<COM1B0|1<<WGM11|0<<WGM10,TCCR1A); 
 // fTCK1 = CK 00000001
 outp(1<<CS10|0<<CS11|0<<CS12,TCCR1B);
 
 
 sbi(DDRD,4); // Datenrichtung PWMA
 sbi(DDRD,5); // Datenrichtung PWMB

// L298 Input
 DDRC|=0x37;
 
 PWMA_Set(0);
 PWMB_Set(0);
}

inline void AForward(void){
  sbi(PORTC,2); //Input 1
  cbi(PORTC,3); //Input 2
}

inline void ABackward(void){
  cbi(PORTC,2); //Input 1
  sbi(PORTC,3); //Input 2
}

inline void AStop(void){
  sbi(PORTC,2); //Input 1
  sbi(PORTC,3); //Input 2
}

inline void BForward(void){
  sbi(PORTC,4); //Input 3
  cbi(PORTC,5); //Input 4
}

inline void BBackward(void){
  cbi(PORTC,4); //Input 3
  sbi(PORTC,5); //Input 4
}

inline void BStop(void){
  sbi(PORTC,4); //Input 3
  sbi(PORTC,5); //Input 4
}


void PWMA_Set(s16 value){
  if (value<0){
    ABackward();
    value= -value;
  } else AForward();
  
  if (value>511) value=511;
  outp(value>>8,OCR1AH); // highbyte setzen
  outp(value   ,OCR1AL); // lowbyte setzen
}

s16 PWMA_Get(void){
   
  if(bit_is_set(PORTC,3))  return  -(inp(OCR1AL)+(inp(OCR1AH)<<8));
   
  return (inp(OCR1AL)+(inp(OCR1AH)<<8));
}

void PWMB_Set(s16 value){
  if (value<0) {
    BBackward();
    value= -value;
  } else BForward();
  
  if (value>511) value=511;
  outp(value>>8,OCR1BH);
  outp(value   ,OCR1BL);
}

s16 PWMB_Get(void){
   
  if(bit_is_set(PORTC,5))
    return  -(inp(OCR1BL)+(inp(OCR1BH)<<8));
   
  return (inp(OCR1BL)+(inp(OCR1BH)<<8));
}
